unit ClientesImplX;

interface

uses InvokeRegistry, Types, XSBuiltIns, ClientesIntf, ClientesImpl;

type

  { TClientesX }
  TClientesX = class(TClientes, IClientes)
  public
    procedure AtualizarStatusPedido; override; stdcall;

    { Servio Especfico do Cliente X }
    function ServicoClienteX: string; stdcall;
  end;

implementation

uses SysUtils, DBXpress, DataClientes;

var
  TD: TTransactionDesc;

{ TClientesX }

procedure TClientesX.AtualizarStatusPedido;
begin
  with dmDataClientes, sqlUpdate do
  begin
    try
      TD.TransactionID := 1;
      TD.IsolationLevel := xilREADCOMMITTED;

      if not SQLConnection.InTransaction then
        SQLConnection.StartTransaction(TD);

      sqlUpdate.CommandText := 'update sales set order_status = '+
       Quotedstr('cancel') + ' where order_status = ' + QuotedStr('waiting') +
        ' and paid = '+ Quotedstr('n');
      sqlUpdate.ExecSQL;
      SQLConnection.Commit(TD);
    except
      SQLConnection.Rollback(TD);
    end;
  end;

end;

function TClientesX.ServicoClienteX: string;
begin
  Result := 'Servio Especfico do Cliente X!';
end;

initialization
  { Invokable classes must be registered }
  InvRegistry.RegisterInvokableClass(TClientesX);

end.
